/* Zeitfunktionen */

-- auf Zeitraster abrunden
-- Einen Zeitstempel auf das Zeitraster abrunden und den Versatz anwenden.
SELECT tsystem.function__drop_by_regex( 'timestamp__floor_to_interval', 'tsystem', _commit => true );
CREATE OR REPLACE FUNCTION tsystem.timestamp__floor_to_interval(
      _timestamp  timestamp,                   -- Zeitstempel
      _time_grid  interval DEFAULT '1 minute', -- Zeitraster bzw. Schrittgröße
      _offset     interval DEFAULT '0 seconds' -- Versatz des Zeitrasters
  )
  RETURNS timestamp
  AS $$
      SELECT  (
                  to_timestamp(
                      floor(
                          EXTRACT( epoch FROM _timestamp )
                        / EXTRACT( epoch FROM _time_grid )
                      )
                    * EXTRACT( epoch FROM _time_grid )
                  )
                + _offset
              ) at time zone 'UTC'
      --SELECT date_bin( _time_grid, _timestamp, '2001-01-01'::timestamp + _offset ) -- Ist performanter, aber die Funktion date_bin gibt es erst ab Postgresql 14.
  $$ LANGUAGE sql STABLE STRICT PARALLEL SAFE;
-- Eine Uhrzeit auf das Zeitraster abrunden und den Versatz anwenden.
CREATE OR REPLACE FUNCTION tsystem.timestamp__floor_to_interval(
      _time       time,                        -- Uhrzeit
      _time_grid  interval DEFAULT '1 minute', -- Zeitraster bzw. Schrittgröße
      _offset     interval DEFAULT '0 seconds' -- Versatz des Zeitrasters
  )
  RETURNS time
  AS $$
      SELECT tsystem.timestamp__floor_to_interval( _timestamp => '2001-01-01'::date + _time, _time_grid => _time_grid, _offset => _offset )::time
      --SELECT date_bin( _time_grid, _timestamp, '2001-01-01'::timestamp + _offset ) -- Ist performanter, aber die Funktion date_bin gibt es erst ab Postgresql 14.
  $$ LANGUAGE sql STABLE STRICT PARALLEL SAFE;
--

-- auf Zeitraster aufrunden
-- Einen timestamp auf das Zeitraster aufrunden und den Versatz anwenden.
SELECT tsystem.function__drop_by_regex( 'timestamp__ceil_to_interval', 'tsystem', _commit => true );
CREATE OR REPLACE FUNCTION tsystem.timestamp__ceil_to_interval(
      _timestamp  timestamp,                            -- Zeitstempel
      _time_grid  interval DEFAULT interval '1 minute', -- Zeitraster
      _offset     interval DEFAULT interval '0 seconds' -- Versatz des Zeitrasters
  )
  RETURNS timestamp
  AS $$
      SELECT  (
                  to_timestamp(
                      ceil(
                          EXTRACT( epoch FROM _timestamp )
                        / EXTRACT( epoch FROM _time_grid )
                      )
                    * EXTRACT( epoch FROM _time_grid )
                  )
                + _offset
              ) at time zone 'UTC'
      --SELECT date_bin( _time_grid, _timestamp + _time_grid - interval '0.000001 seconds', '2000-01-01'::timestamp + _offset ) -- Ist performanter, aber die Funktion date_bin() gibt es erst ab Postgresql 14.
  $$ LANGUAGE sql STABLE STRICT PARALLEL SAFE;
-- Eine Uhrzeit auf das Zeitraster aufrunden und den Versatz anwenden.
CREATE OR REPLACE FUNCTION tsystem.timestamp__ceil_to_interval(
      _time       time,                        -- Uhrzeit
      _time_grid  interval DEFAULT '1 minute', -- Zeitraster bzw. Schrittgröße
      _offset     interval DEFAULT '0 seconds' -- Versatz des Zeitrasters
  )
  RETURNS time
  AS $$
      SELECT tsystem.timestamp__ceil_to_interval( _timestamp => '2001-01-01'::date + _time, _time_grid => _time_grid, _offset => _offset )::time
      --SELECT date_bin( _time_grid, _timestamp, '2001-01-01'::timestamp + _offset ) -- Ist performanter, aber die Funktion date_bin gibt es erst ab Postgresql 14.
  $$ LANGUAGE sql STABLE STRICT PARALLEL SAFE;
--